<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo h($website_title); ?></title>
        <?php echo $this->Html->meta('description', $website_description); ?>

        <link href="<?php echo $this->Html->url('/frontend/lib/bootstrap/css/bootstrap.min.css'); ?>" rel="stylesheet">
        <link href="//maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet">
        <link href="<?php echo $this->Html->url('/frontend/lib/animate.css/animate.min.css'); ?>" rel="stylesheet">
        <link href='//fonts.googleapis.com/css?family=Lato:300,400,700,900' rel='stylesheet' type='text/css'>
        <link href="<?php echo $this->Html->url('/frontend/css/app.css'); ?>" rel="stylesheet">

        <!--[if lt IE 9]>
          <script src="//oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
          <script src="//oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <?php echo Configure::read('Option.head_code'); ?>
    </head>
    <body>
        <?php echo Configure::read('Option.after_body_tag_code'); ?>
        <header>
            <nav class="navbar navbar-default navbar-fixed-top" role="navigation">
                <div class="container">
                    <!-- Brand and toggle get grouped for better mobile display -->
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                            <span class="fa fa-bars fa-lg"></span>
                        </button>
                        <a class="navbar-brand" href="<?php echo $this->Html->url('/'); ?>">
                            <?php echo h(Configure::read('Option.site_name')); ?>
                        </a>
                    </div>

                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">

                        <ul class="nav navbar-nav navbar-right">
                            <li><a href="<?php echo $this->Html->url('/login'); ?>"><i class="fa fa-sign-in" aria-hidden="true"></i> <?php echo __('My Account') ?></a></li>
                        </ul>
                    </div>
                    <!-- /.navbar-collapse -->
                </div>
                <!-- /.container-->
            </nav>
        </header>

        <?php if (isset($this->request->params[ 'action' ]) && $this->request->params[ 'action' ] == 'home') {
    ?>
            <div class="container">
                <?php echo $this->Flash->render();
    ?>
            </div>
            <?php echo $this->fetch('content');
    ?>
        <?php 
} else {
    ?>
            <div class="container">
                <?php echo $this->Flash->render();
    ?>
                <?php echo $this->fetch('content');
    ?>
            </div>
        <?php 
} ?>

        <footer>
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="pull-left social">
                            <?php if (Configure::read('Option.twitter_url')) {
    ?>
                                <a target="_blank" href="<?php echo h(Configure::read('Option.twitter_url'));
    ?>"><i class="fa fa-twitter"></i></a>
                            <?php 
} ?>
                            <?php if (Configure::read('Option.facebook_url')) {
    ?>
                                <a target="_blank" href="<?php echo h(Configure::read('Option.facebook_url'));
    ?>"><i class="fa fa-facebook"></i></a>
                            <?php 
} ?>
                            <?php if (Configure::read('Option.googleplus_url')) {
    ?>
                                <a target="_blank" href="<?php echo h(Configure::read('Option.googleplus_url'));
    ?>"><i class="fa fa-google-plus"></i></a>
                            <?php 
} ?>
                        </div>
                        <div class="pull-right">
                            <ul class="list-inline">
                                <li><a href="<?php echo $this->Html->url('/'); ?>"><?php echo __('Home') ?></a></li>
                                <li><a href="<?php echo $this->Html->url('/pages/terms'); ?>"><?php echo __('Terms of Use') ?></a></li>
                                <li><a href="<?php echo $this->Html->url('/pages/privacy'); ?>"><?php echo __('Privacy Policy') ?></a></li>
                                <li><a href="<?php echo $this->Html->url('/pages/dmca'); ?>"><?php echo __('DMCA') ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="rights text-center">
                    <?php echo __('Copyright &copy; %s | Developed by %s', date('Y'), '<a href="http://www.mightyscripts.com" target="_blank">MightyScripts</a>') ?>
                </div>
            </div>
        </footer>

        <script src="<?php echo $this->Html->url('/frontend/js/jquery.min.js'); ?>"></script>
        <script src="<?php echo $this->Html->url('/frontend/lib/bootstrap/js/bootstrap.min.js'); ?>"></script>
        <script src="<?php echo $this->Html->url('/frontend/lib/wow/wow.min.js'); ?>"></script>
        <script src="//cdnjs.cloudflare.com/ajax/libs/waypoints/2.0.3/waypoints.min.js"></script>
        <script src="<?php echo $this->Html->url('/frontend/lib/counter-up/jquery.counterup.js'); ?>"></script>
        <script src="<?php echo $this->Html->url('/frontend/lib/jquery.particleground.min.js'); ?>"></script>
        <script type='text/javascript'>
            /* <![CDATA[ */
            var app_vars = [ ];
            app_vars['base_url'] = '<?php echo $this->Html->url('/', true); ?>';
            /* ]]> */
        </script>
        <script src="<?php echo $this->Html->url('/frontend/js/app.js'); ?>"></script>
        <?php echo $this->fetch('scriptBottom'); ?>
        <?php echo Configure::read('Option.footer_code'); ?>
    </body>
</html>
